<?php
header('Content-Type: application/json; charset=utf-8');

// Connect to the MySQL database
require_once "database.php";

$sender_id = $_GET['si'];
$receiver_id = $_GET['ri'];

// Initial query to retrieve distinct participant pairs
$sql = "SELECT DISTINCT LEAST(sender_id, receiver_id) AS participant1, GREATEST(sender_id, receiver_id) AS participant2
FROM message
WHERE (sender_id = $sender_id OR receiver_id = $sender_id)
  OR (sender_id = $receiver_id OR receiver_id = $receiver_id)
  AND id NOT IN ($sender_id, $receiver_id)";

$result = mysqli_query($connection, $sql);

$data = [];

if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        // Fetch latest message for each participant pair
        $participant1 = $row['participant1'];
        $participant2 = $row['participant2'];

        $sql = "SELECT *
                FROM message
                WHERE (sender_id = $participant1 AND receiver_id = $participant2)
                  OR (sender_id = $participant2 AND receiver_id = $participant1)
                ORDER BY time DESC
                LIMIT 1";

        $message_result = mysqli_query($connection, $sql);

        if ($message_result && mysqli_num_rows($message_result) > 0) {
            $message_data = mysqli_fetch_assoc($message_result);
            $data[] = [
                'participant1' => $participant1,
                'participant2' => $participant2,
                'message' => $message_data['message'],
                'id' => $message_data['id'],
                'time' => $message_data['time']
            ];
        } else {
            $data[] = [
                'participant1' => $participant1,
                'participant2' => $participant2,
                'error' => 'No messages found for this conversation'
            ];
        }

        mysqli_free_result($message_result);
    }

    echo json_encode($data);
} else {
    echo json_encode(['error' => 'No conversations found']);
}

mysqli_free_result($result);
?>
