<?php
header('Content-Type: application/json');

// Enable error reporting for debugging
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Database connection
$host = "localhost";
$dbname = "iconnect_rgc";
$username = "iconnect_rgc";
$password = "uCW4i3tqMVkChG_";

$conn = new mysqli($host, $username, $password, $dbname);
$conn->set_charset("utf8mb4"); // ✅ This line ensures Bangla text is handled correctly


if ($conn->connect_error) {
    echo json_encode(["status" => "error", "message" => "Connection failed"]);
    exit();
}

// Get POST data safely
$transaction_id       = $_POST['transaction_id'] ?? null;
$contact_id       = $_POST['contact_id'] ?? null;
$user_id          = $_POST['user_id'] ?? null;
$gave_amount      = $_POST['gave_amount'] ?? 0;
$received_amount  = $_POST['received_amount'] ?? 0;
$description      = $_POST['description'] ?? '';
$transaction_date = $_POST['transaction_date'] ?? '';
$created_at       = $_POST['created_at'] ?? '';
$sync_status      = $_POST['sync_status'] ?? '';

// Prepare SQL without transaction_id
$sql = "INSERT INTO transactions (
            transaction_id,contact_id, user_id,
            gave_amount, received_amount, description,
            transaction_date, created_at, sync_status
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);
$stmt->bind_param("iiiddssss",
    $transaction_id, $contact_id, $user_id,
    $gave_amount, $received_amount, $description,
    $transaction_date, $created_at, $sync_status
);

if ($stmt->execute()) {
    // Get the auto-generated transaction_id
    $new_id = $stmt->insert_id;
    echo json_encode(["status" => "success", "transaction_id" => $new_id]);
} else {
    echo json_encode(["status" => "error", "message" => $stmt->error]);
}

$stmt->close();
$conn->close();
?>